function [r,v_l,v_s]=simulate_heston_two_factors(ndays,nintra,params,delta_day,w1,w2,w3,w4)

kappa_1=params(1);
kappa_2=params(2);
omega=params(3);
eta_1=params(4);
eta_2=params(5);
rho_1=0;
rho_2=0;

minvalue = 1.e-12;
delta = delta_day/nintra;


V_t_1 = zeros(1,ndays*nintra);

wl = rho_1*w1 + sqrt(1-rho_1^2)*w2;
wl = reshape(wl,ndays*nintra,1);

V_t_2 = zeros(1,ndays*nintra);
ws = rho_2*w3 + sqrt(1-rho_2^2)*w4;
ws = reshape(ws,ndays*nintra,1);

V_t_1(1,1) = omega;
V_t_2(1,1) = omega;

std_l = (eta_1^2/(2*kappa_1))*(1-exp(-kappa_1*delta))^2*omega;
std_2 = (eta_1^2/kappa_1)*exp(-kappa_1*delta)*(1-exp(-kappa_1*delta));

std_3 = (eta_2^2/(2*kappa_2))*(1-exp(-kappa_2*delta))^2*omega;
std_4 = (eta_2^2/kappa_2)*exp(-kappa_2*delta)*(1-exp(-kappa_2*delta));

for j=2:ndays*nintra
    mean_v_1 = omega*(1-exp(-kappa_1*delta))+V_t_1(1,j-1)*exp(-kappa_1*delta);
    var_v_1 = std_2*V_t_1(1,j-1)+std_l;
    V_t_1(1,j) = mean_v_1 + sqrt(var_v_1)*wl(j,1); 
    V_t_1(1,j) = max(V_t_1(1,j),minvalue);
    
    mean_v_2 = omega*(1-exp(-kappa_2*delta))+V_t_2(1,j-1)*exp(-kappa_2*delta);
    var_v_2 = std_4*V_t_2(1,j-1)+std_3;
    V_t_2(1,j) = mean_v_2 + sqrt(var_v_2)*ws(j,1); 
    V_t_2(1,j) = max(V_t_2(1,j),minvalue);

end;
r = (sqrt(V_t_1)'.*w1)*sqrt(delta)+(sqrt(V_t_2)'.*w3)*sqrt(delta);
v_l = reshape(V_t_1,nintra,ndays);
v_s = reshape(V_t_2,nintra,ndays);
r = reshape(r,nintra,ndays);
end